'Mandelbrot Explorer16 V1.3 for Color Maximite 2
'By the Sasquatch
'with thanks to matherp, vegipete, thwill and yock1960 for your contributions
'www.thebackshed.com

Setup:
  'Screen Resolution set here, designed for Mode 1,16
  'Should work at any reasonable resolution with at least 3 graphics pages
  'Currently Z)oom cursor mode requires 3 pages everything else should work with 2
  Mode 1,16      '800 X 600 for compatabliliy with MMBasic V5.05.04
  CLS
' modfile variables
  dim f%, fno%. amode%, fnmaxlen%
  dim m$, mdir$, md$(100) ' handle up to 100 modfiles, seems like enough?
  dim interval% 'how long was the last screen draw, used for roll colors  

  fno% = -1         ' default modfile play off
  mdir$ = "" 
  amode% = 0
  defflg% = 0
  XMax = MM.HRES - 1
  YMax = MM.VRES - 1
  XCursor = XMax / 2
  YCursor = YMax / 2

  KeyCount = 1
  

  CONST True = 1
  CONST False = 0
  SFileName$ = "MandelBrot.bmp"
  FileName$ = "MandelBrot.dat"

  Zoom = 2.0
  Depth% = 64 
  Scale! = 1.0
  XCenter! = -0.7
  YCenter! = 0.0
  HStart! = 120.0
  HMult! = 6.0

  Dim XUndo(100)
  Dim YUndo(100)
  Dim SUndo(100)
  Dim DUndo(100)
  Dim HSUndo(100)
  Dim HMUndo(100)

  Refresh = True
  Push = True
  Done = False
  RollColors = False
  RollDepth = False
  CList = False
  HaveChuk = False
  HaveClassic = False
  ZoomMode = False
  RefreshCursor = False

  cursor_visible = False
  ST_Flag = True

  T = Timer

  MakeSprite

  HelpScreen

  'Check for Wii Nunchuk
  On Error Skip 1
    Wii Nunchuk Open 
  If MM.ERRNO = 0 Then
   If Nunchuk(T) = &HA4200000 Then  'Check for original style nunchuk 
     HaveChuk = True
   Else 
     Wii Nunchuk Close
   End If
  End If

  If Not HaveChuk Then 
    'Check for Wii Classic Controller
    On Error Skip 1
      Wii Classic Open 
    If MM.ERRNO = 0 Then
     If Classic(T) = &HA4200101 Then  'Check for Classic 
       HaveClassic = True
     Else 
       Wii Classic Close
     End If
    End If
  End If  


MainLoop:
Do  'Main Loop Starts Here
  Key$ = Inkey$              'Read Key from console buffer
  'Process Cursor Keys
  If KeyDown(0) Then         'Read Key on USB keyboard
    For X = 1 to KeyDown(0)
      K = KeyDown(X)
      move_cursor(K)
    Next X

    ' Refresh Cursor Sprite
    If K >= 128 And K <= 131 Then
       RefreshCursor = True

      'Make the cursor move faster if key held down
      KeyCount = KeyCount + 1
      If KeyCount > 18 Then KeyCount = 18
      Pause(190 - KeyCount * 10)
    EndIf

  Else If Key$ <> "" Then   'Key from Console buffer
    K = Asc(Key$)
    move_cursor(K)

  Else
    ' If Key not pressed, reset key held count
    KeyCount = 1
    K = 0
  EndIf
 
  If HaveChuk Then
     If Nunchuk(Z) = 1 Then K = 73 'Zoom in
     If Nunchuk(C) = 1 Then K = 67 'Re-Center
     XChuk = Nunchuk(JX)
     YChuk = Nunchuk(JY)
  End If

  If HaveClassic Then
     ClassB = Classic(B)
     
      if (ClassB AND 1) Then K = 62 'R Button next mod track
'        if fno% <> 0 then
'          settick 0,0,1
'          nextmod()
'          settick 300000,nextmod,1
'        end if
'      end if
        
     if (ClassB AND 4) Then K = 134 'home button reset
     if (ClassB AND 8) Then K = 77  'select button color map
     if (ClassB AND 16) Then K = 60 'L button previous track



     if (ClassB AND 1024) Then K = 73 'X button Zoom in
     if (ClassB AND 2048) Then K = 68 'A button Zoom out    
     if (ClassB AND 4096) Then K = 79 'y button Zoom out
     if (ClassB AND 8192) Then K = 67 'B button re-Center
     XChuk = Classic(LX)
     YChuk = Classic(LY)    
  End IF

  If HaveChuk Or HaveClassic Then
     If XChuk > 140 Then XCursor = XCursor + (XChuk - 140) / 250
     If XCursor > XMax Then XCursor = XMax
     If XChuk < 116 Then XCursor = XCursor - (116 - XChuk) / 250
     If XCursor < 0 Then XCursor = 0

     If YChuk > 140 Then YCursor = YCursor - (YChuk - 140) / 250
     If YCursor < 0 Then YCursor = 0
     If YChuk < 115 Then YCursor = YCursor + (115 - YChuk) / 250
     If YCursor > YMax Then YCursor = YMax
     If XCursor <> XOld or YCursor <> YOld Then
       RefreshCursor = True
       XOld = XCursor : YOld = YCursor
       If Not ZoomMode and Not Clist Then Pause 5
     End If
   End If

  'Now Check for other Key Commands
  If K <> 0 Then 

    If K = 134 Then               '<Home>
    'Home Key Reset everything
      Zoom = 2.0
      Depth% = 64
      Scale! = 1.0
      XCenter! = -0.70
      YCenter! = 0.0
      HStart! = 120.0
      HMult! = 6.0
      Refresh = True
      RollColors = False
      RollDepth = False
      Map Reset

  
    Else IF K = 65 or K = 97 then    'A Key - modfile autoplay
      if fno% = -1 then
        print @(0,1) "Music play is off!"
        Pause 2000
      else 
        if amode% = 0 then
'          Print @(0,1) "Modfile autoplay enabled"
          settick 300000,nextmod,1
          amode% = 1
          Q = Timer
        else
'          Print @(0,1) "Modfile autoplay disabled"
          settick 0,0,1
          amode% = 0
        end if
      end if
    'Refresh = True    
    Page Copy 1,0
    RefreshCursor = True
    Pause 400
     

    Else IF K = 60 or K = 44 then '< previous mod track
        if fno% <> -1 then
          play stop
          if f% >= 1 then
            f% = f% - 1
          else
            f% = fno%-1
          end if
          m$ = mdir$+"/"+md$(f%)
          if amode% then Q = Timer
          play modfile m$,22050

'        print "playing " + md$(f%)
        end if
        'Refresh = True
        Page Copy 1,0
        RefreshCursor = True
        pause(400)


    Else IF K = 62 or K = 46 then '> next mod track
        if fno% <> -1 then
          play stop
          if f% < fno%-1 then
            f% = f% + 1
          else
            f% = 0
          end if
          m$ = mdir$+"/"+md$(f%)
          if amode% then Q = Timer
          play modfile m$,22050
'          print "playing " + md$(f%)
        end if
        'Refresh = True
        Page Copy 1,0
        RefreshCursor = True
        pause(400)



    Else IF K = 67 or K = 99 Then  'C or c
      'Re center at cursor    
      UpdateToCursor
      Refresh = True

    Else IF K = 73 Or K = 105 Then 'I or i
      'Zoom in at cursor center
      UpdateToCursor
      Scale! = Scale! * Zoom
      Refresh = True

    Else IF K = 78 Or K = 110 Then  'N or n
      'next mod track
        if fno% = -1 then
          getmod()
        else
          settick 0,0,1
          play stop
          fno% = -1
        end if
        'pause(200)
        'Refresh = True       
        Page Copy 1,0
        RefreshCursor = True
        Pause 400


    Else IF K = 79 Or K = 111 Then  'O or o
      'Zoom out at cursor center
      UpdateToCursor
      Scale! = Scale! / Zoom
      Refresh = True

    Else If K = 90 or K = 122 Then  'Z or z
      If ZoomMode Then
        ZoomMode = False
        Zoom = NewZoom
        BoxW = 0
        Page Copy 1,0
      Else  
      'Turn Zoom mode on
        Page Write 2
        CLS
        Page Write 0
        NewZoom = Zoom
        ZoomMode = True
      End If
      RefreshCursor = True
      Pause(200)

    Else IF K = 81 Or K = 113 Then  'Q or q
      'Time to Quit
      Done = True
      settick 0,0,1

    Else IF K = 83 Or K = 115 Then  'S or s
      'Save as Bitmap
      Print @(0,0) "Save Bitmap - Please Be Patient "
      Print "Saving the image will take a few seconds "
      Print "File name for Save [";SFileName$;"]";
      Input ;Res$
      If Res$ <> "" Then
          SFileName$ = Res$    
      EndIf
      hide_cursor()
      'Refresh the Image
      Page Copy 1 To 0,B
      'Now save to file
      Save Image SFileName$
      Print @(0,0) "Save Image Done "
      Refresh = True

    Else IF K = 68 Or K = 100 Then  'D or d
      'Prompt for new Depth
      Page Copy 1 To 0,B
      Print @(0,0) "Enter Depth (Iterations) ["+STR$(Depth%)+"]";
      Input ;Res$
      If Res$ <> "" And Val(Res$) > 0 And Val(Res$) <= 5000 Then
        Depth% = Val(Res$)
        Refresh = True
      Else
        Page Copy 1 To 0,B
        Pause(200)  
      EndIf

    Else IF K = 69 Or K = 101 Then  'E or e
     'Prompt for new coordinates
     Page Copy 1 To 0,B
     Print @(0,0) "Enter Scale ["+STR$(Scale!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > 0.0 And Val(Res$) <= 1E13 Then
        SCALE! = Val(Res$)
        Refresh = True
      EndIf
     Print "Enter X Center ["+STR$(XCenter!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > -2.0 And Val(Res$) < 2.0 Then
        XCenter! = Val(Res$)
        Refresh = True
      EndIf
     Print "Enter Y Center ["+STR$(YCenter!)+"]";
     Input ;Res$
      If Res$ <> "" And Val(Res$) > -2.0 And Val(Res$) < 2.0 Then
        YCenter! = Val(Res$)
        Refresh = True
      EndIf
     If Not Refresh Then
       Page Copy 1 To 0,B
       Pause(200)
     EndIf
    
    Else IF K = 76 Or K = 108 Then  'L or l
      'List Current Coordinates On/Off
      If CList Then
        CList = False
        Page Copy 1 To 0,B
      Else 
        CList = True
      End If
      Pause(200)

    Else IF K = 72 Or K = 104 Or K = 63 Then 'H or h or ?
      'Show Help Screen
      hide_cursor()
      HelpScreen
      Page Copy 1 To 0,B
      RefreshCursor = True
      Pause(200)

    Else IF K = 70 Or K = 102 Then  'F or f
      'File Menu???
      hide_cursor()
      FileMenu
      Page Copy 1 To 0,B
      RefreshCursor = True
      Pause(200)

    Else IF K = 82 Or K = 114 Then  'R or r
      'Toggle Roll Colors On/Off
      If RollColors Then
        RollColors = False
      else
        RollColors = True
      EndIf
      Pause(200)
      Refresh = True

    Else IF K = 84 Or K = 116 Then  'T or t
      'Toggle Roll Colors On/Off
      If RollDepth Then
        RollDepth = False
      else
        RollDepth = True
      EndIf
      Pause(200)
      Refresh = True


    Else IF K = 77 Or K = 109 Then  'M or m
      'Reset Color Map 
      Page Copy 1 To 0,B
      Print @(0,0) "Enter Hue Start` ["+STR$(HStart!)+"`]";
      Input ;Res$
      If Res$ <> "" And Val(Res$) >= -360.0 And Val(Res$) <= 360.0 Then
        HStart! = Val(Res$)
        Refresh = True
      End If
      Print "Enter Hue Multiplier "+STR$(HMult!)+"]";
      Input ;Res$
      If Res$ <> "" And Val(Res$) <> 0.0 And Val(Res$) >= -100.0 And Val(Res$) <= 100.0 Then
        HMult! = Val(Res$)
        Refresh = True
      End If
      If Not Refresh Then
        Page Copy 1 To 0,B
        Pause(200)  
      EndIf


    Else IF K = 80 Or K = 112 Then  'P or p
      'Show Color Map Help Screen
      hide_cursor()
      CPick
      Page Copy 1 To 0,B
      RefreshCursor = True

      If Not Refresh Then
        Page Copy 1 To 0,B
        Pause(200)  
      EndIf



    Else IF K = 85 Or K = 117 Then  'U or u
      'Undo last coordinate change 
       PopUndo 'Get previous coordinates from the undo buffer
       Push = False
       Pause(200)

    Else If ZoomMode Then  ' Commands only if Zoom cursor on
      If K = 27 Then             '<Esc>
        ZoomMode = False
        Page Copy 1,0
        RefreshCursor = True
      End If

      If K = 10 Then        '<Enter>
        ZoomMode = False
        UpdateToCursor
        Zoom = NewZoom
        Scale! = Scale! * Zoom
        Refresh = True
      End If

      If K = 43 Or K = 61 Then  '+ or =
       NewZoom = NewZoom * 2
       If NewZoom > 32.0 Then NewZoom = 32.0
       RefreshCursor = True
       Pause(200)
      End If

      If K = 45 Or K = 95 Then   '- Or _
       NewZoom = NewZoom / 2
       If NewZoom < 1.0 Then NewZoom = 1.0
       RefreshCursor = True
       Pause(200)
      EndIf


    EndIf  'If ZoomMode Then

  EndIf  'If K <> 0 Then

  If Refresh Then
    hide_cursor()
    'Call the Mandelbrot CSUB to render the image
    S = Timer
    Mandelbrot16 Depth%,Scale!,XCenter!,YCenter!,HStart!,HMult!
    interval% = Timer - S
    Page Copy 0 TO 1
    XCursor = XMax / 2
    YCursor = YMax / 2 
    If Push Then PushUndo ' Push the new coordinates into the undo buffer
    Push = True
    Refresh = False
    show_cursor()
    Do While Inkey$ <> "" : Loop
    
  EndIf


  If CList Then
      font 7,1
      text 5,2, "XC=[", L,7,,RGB(CYAN)
      if XCenter = XCenter! + (XCursor - XMax / 2) / XMax * 3 / Scale! then
        text 27,2,str$(XCenter!,-1,12),L,7,,RGB(CYAN)
        text 117,2,"] ",L,7,,RGB(CYAN)


     else
        xtemp! = XCenter! + (XCursor - XMax / 2) / XMax * 3 / Scale! 
        text 27,2,str$(xtemp!,-1,12),L,7,,RGB(CYAN)
        text 117,2,"] ",L,7,,RGB(CYAN)

      end if
      text 129,2,"YC=[",L,7,,RGB(CYAN)

      if YCenter! = YCenter! + (YMax / 2 - YCursor) / YMax * 3 / Scale! then
        text 151,2,str$(YCenter!,-1,12),L,7,,RGB(CYAN)
        text 241,2,"] ",L,7,,RGB(CYAN)

      else
        ytemp! = YCenter! + (YMax / 2 - YCursor) / YMax * 3 / Scale!
        text 151,2,str$(ytemp!,-1,12),L,7,,RGB(CYAN)
        text 241,2,"] ",L,7,,RGB(CYAN)

      end if

      text 253,2,"Scale=["
      
      if Scale! <= 1024 then
        text 295,2,str$(Scale!,6)+"] ",L,7

      else if Scale! <= 524288 then
        text 295,2,str$((Scale!/1024),5)+"K] ",L,7
      else if Scale! <= 536870912 then
        text 295,2,str$((Scale!/1048576),5)+"M] ",L,7
      else if Scale! <= 549755813900 then
        text 295,2,str$((Scale!/1073741824),5)+"G] ",L,7
      end if
      text 343,2,"Depth=[",L,7

      text 385,2,str$(Depth%,3)+"] ",L,7  

      text 415,2,"Hue=[",L,7,,RGB(GREEN)

      text 445,2,str$(Hstart!,3)+"] ",L,7,,RGB(GREEN)

      text 475,2,"Hmult[",L,7,,RGB(GREEN)

      text 511,2,str$(Hmult!,4)+"] ",L,7,,RGB(GREEN)

      if fno% <> -1 then
        text 547,2,"Playing ["+space$(fnmaxlen%-len(md$(f%)))+left$(md$(f%),(instr(1,md$(f%),".")-1))+"] ",L,7,,RGB(YELLOW)
        elp = int(8-((Timer-Q)/37500))+1
        if amode% then
          text 547+48+(fnmaxlen%-1)*6,2,left$("Autoplay",elp),L,7,,RGB(GREEN)
          text 547+48+(fnmaxlen%-1)*6+elp*6,2,right$("Autoplay",8-elp),L,7,,RGB(RED) 
        end if
      else
        text 547,2,"Music off",L,7,,RGB(RED)

      end if
      font 1,1      
  EndIf



  If RefreshCursor Then
    If ZoomMode Then
      Page Write 2
'      CLS
      If BoxW <> 0.0 Then Box BoxX,BoxY,BoxW,BoxH,,0
      BoxX = XCursor-(XMax/NewZoom)/2
      BoxY = YCursor-(YMax/NewZoom)/2
      BoxW = Xmax/NewZoom
      BoxH = YMax/NewZoom
      Box BoxX,BoxY,BoxW,BoxH 
      Page Write 0
      Page XOR_PIXELS 1,2,0   
      If Not CList Then
        Print @(0,0) "Zoom Factor ["+STR$(Zoom)+"]"; NewZoom;" "
      End If
    End If
    show_cursor()

    RefreshCursor = False
  End If


 ' 1.5 seconds to decide
If RollColors And Timer - T > (interval% + 1500) Then
    T = Timer
        'HStart! = HStart! + 60
        'Refresh = True 
        if Hmult! < 91 then
          HMult! = Hmult! + 10
        else if Hmult! >= 91 then
          Hmult! = -100
        end if
        Refresh = True

  EndIf
  

 ' 1.5 seconds to decide
If RollDepth And Timer - T > (interval% + 1500) Then
    T = Timer
        
        if Depth% = 256 then
          Depth% = 16
        else
          Depth% = Depth% + 16
        end if
        Refresh = True

  EndIf
Do While Inkey$ <> "" : Loop


Loop While Not Done  'End of Main Loop

Map Reset
If HaveChuk Then Wii Nunchuk Close
If HaveClassic Then Wii Classic Close
CLS

End


Sub move_cursor(k)
  Select Case k
    Case 128 ' Up Arrow
      YCursor = YCursor - 1
      If YCursor < 0 Then YCursor = 0
    Case 129 ' Down Arrow
      YCursor = YCursor + 1
      If YCursor > YMax Then YCursor = YMax
    Case 130 ' Left Arrow
      XCursor = XCursor - 1
      If XCursor < 0 Then XCursor = 0
    Case 131 ' Right Arrow
      XCursor = XCursor + 1
      If XCursor > XMax Then XCursor = XMax
    Case Else
      Exit Sub
  End Select

  RefreshCursor = True
End Sub

Sub show_cursor()
  Sprite Show 1,XCursor-16,YCursor-16,1
  cursor_visible = True
End Sub

Sub hide_cursor()
  If cursor_visible Then Sprite Hide 1
  cursor_visible = False
End Sub

'Push current coordinates into Undo buffer
Sub PushUndo
   For i = 98 to 1 step -1
     XUndo(i) = XUndo(i-1)
     YUndo(i) = YUndo(i-1)
     DUndo(i) = DUndo(i-1)
     SUndo(i) = SUndo(i-1)
     HSUndo(i) = HSUndo(i-1)
     HMUndo(i) = HMUndo(i-1)
   Next i

   XUndo(0) = XCenter!
   YUndo(0) = YCenter!
   SUndo(0) = Scale!
   DUndo(0) = Depth%
   HSUndo(0) = HStart!
   HMUndo(0) = HMult!
End Sub

'Pop coordinates from Undo buffer
Sub PopUndo
  For i = 0 to 99
    XUndo(i) = XUndo(i+1)
    YUndo(i) = YUndo(i+1)
    SUndo(i) = SUndo(i+1)
    DUndo(i) = DUndo(i+1)
    HSUndo(i) = HSUndo(i+1)
    HMUndo(i) = HMUndo(i+1)
  Next i

  If DUndo(0) <> 0 Then
    XCenter! = XUndo(0)
    YCenter! = YUndo(0)
    Scale! = SUndo(0)
    Depth% = DUndo(0)
    HStart! = HSUndo(0)
    HMult! = HMUndo(0)
    Refresh = True
  End If
End Sub


Sub UpdateToCursor
  'Calculate new Mandelbrot coordinates from cursor position
  XCenter! = XCenter! + (XCursor - XMax / 2) / XMax * 3 / Scale!
  YCenter! = YCenter! + (YMax / 2 - YCursor) / YMax * 2.5 / Scale!
End Sub


SUB MakeSprite
  'Draw the cursor sprite and then read from screen
  CLS
  Line 14,0,14,29,1,RGB(8,8,8)
  Line 15,0,15,29,1
  Line 16,0,16,29,1,RGB(8,8,8)
  Line 0,14,29,14,1,RGB(8,8,8)
  Line 0,15,29,15,1
  Line 0,16,29,16,1,RGB(8,8,8)
  Circle 15,15,11,1,,RGB(8,8,8)
  Circle 15,15,10,1
  Circle 15,15,2,1,,0,0
  Sprite Read 1,0,0,30,30
  CLS
End Sub


Sub FileMenu
  Do While Inkey$ <> "" : Loop
  CLS
  Print:Print
  Print "File Menu"
  Print:Print
  FName$ = Dir$("*.Dat",FILE)
  Do While FName$ <> ""
    IF Left$(FName$,1) <> "." Then Print FName$
    FName$ = Dir$()
  Loop
  Print:Print
  Print "Press   L)oad   S)ave   D)one :"
  FileDone = False
  Do
    R$ = Inkey$
    If R$ = "D" Or R$ = "d" Then
      FileDone = True
    Else If R$ = "L" Or R$ = "l" Then
      Pause(400)
      OldFileName$ = FileName$
      Print"File Name to Load:["+FileName$+"]"; :Input;FileName$
      if FileName$ = "" Then FileName$ = OldFileName$
      if Instr(1,FileName$,".") = 0 Then FileName$ = FileName$ + ".Dat"
      On Error Skip 1
        Open FileName$ for Input As #1
      If MM.ERRNO = 0 Then
        Print "Loading: ";FileName$
        Input #1, XCenter!
        Input #1, YCenter!
        Input #1, Scale!
        Input #1, Depth%
        If Not EOF(#1) Then
          Input #1, HMult!
          Input #1, HStart!
        Else
          HMult! = 1.0
          HStart! = 0.0
        End If
        If Not EOF(#1) Then
          Input #1, mdir$
          Input #1, fno%
          Input #1, amode%
        End if
        Close #1
        
        if mdir$ <> "" then
          if amode% = 1 then
            play stop
          end if
          getmod()
          if amode% = 1 then
            Q = TIMER
            settick 300000,nextmod,1
          end if

        end if
        Refresh = True
      Else
        Print "File Error: ";MM.ERRNO
        Pause 2000
      EndIf
      FileDone = True
    Else If R$ = "S" Or R$ = "s" Then
      Pause(400)
      OldFileName$ = FileName$
      Print"File Name to Save:["+FileName$+"]"; :Input;FileName$
      if FileName$ = "" Then FileName$ = OldFileName$
      If Instr(1,FileName$,".") = 0 Then FileName$ = FileName$ + ".Dat"
      On Error Skip 1
        Open FileName$ for Output As #1
      If  MM.ERRNO = 0 Then
        Print "Saving: ";FileName$
        Print #1,STR$(XCenter!,0,15)
        Print #1,STR$(YCenter!,0,15)
        Print #1,Scale!
        Print #1,Depth%
        Print #1,HMult!
        Print #1,HStart!
        Print #1,mdir$
        Print #1,fno%
        Print #1,amode%
        Close #1
      Else
        Print "File Error: ";MM.ERRNO
        Pause 2000
      End IF        
      FileDone = True
    End If
        Pause(400)
  Loop While Not FileDone
  Do While Inkey$ <> "" : Loop  
  CLS
End Sub

Sub CheckDefault
  if defflg% = 0 then
    def$ = "default.dat"
  else
    def$ = "user.dat"
  end if    
 
  FName$ = Dir$("*.Dat",FILE)
  Do While FName$ <> ""
    FName$ = Dir$()
    if FName$ = def$ then
      exit do
    end if
  Loop
      if def$ <> "" then
        On Error Skip 1
          Open def$ for Input As #1
        If MM.ERRNO = 0 Then
          Input #1, XCenter!
          Input #1, YCenter!
          Input #1, Scale!
          Input #1, Depth%
          If Not EOF(#1) Then
            Input #1, HMult!
            Input #1, HStart!
          Else
            HMult! = 1.0
            HStart! = 0.0
          End If
          Input #1, mdir$
          Input #1, fno%
          Input #1, amode%
          Close #1
        Else
          Print "File Error: ";MM.ERRNO
          Pause 2000
        EndIf
        
         if mdir$ <> "" then
          getmod()
         end if
         if amode% then
            Q = Timer
            settick 300000,nextmod,1
         end if

       Refresh = True
        
      end if
      defflg% = 0    
end sub


Sub CPick
  CLS

  For An = 0 To 359.9 step 0.1
    Ab = (An - 90) * Pi / 180
    SinA = SIN(Ab)
    CosA = COS(Ab)  
    line XMax/2+50*CosA,200+50*SinA,XMax/2+150*CosA,200+150*SinA,,HtoRGB(An,255)
     
'    line XMax/2+50*CosA,200+50*SinA,XMax/2+100*CosA,200+100*SinA,,HtoRGB(An,128)
'    line XMax/2+100*CosA,200+100*SinA,XMax/2+150*CosA,200+150*SinA,,HtoRGB(An,255)
  Next An

  Print @(XMax/2-20,180)"Color"
  Print @(XMax/2-20,195)" Hue`"
  Print @(XMax/2-20,210)"R,G,B"

  Print @(XMax/2-20,5)" Red "
  Print @(XMax/2-20,20)"  0` "
  Print @(XMax/2-30,35)"255,0,0"

  Print @(XMax/2+130,65)"Yellow"
  Print @(XMax/2+130,80)"  60` "
  Print @(XMax/2+120,95)"255,255,0"

  Print @(XMax/2+130,295)"Green"
  Print @(XMax/2+130,310)" 120` "
  Print @(XMax/2+125,325)"0,255,0"

  Print @(XMax/2-20,355)" Cyan "
  Print @(XMax/2-20,370)" 180` "
  Print @(XMax/2-30,385)"0,255,255"

  Print @(XMax/2-170,295)" Blue"
  Print @(XMax/2-170,310)" 240` "
  Print @(XMax/2-180,325)"0,0,255"

  Print @(XMax/2-195,65)"Magenta"
  Print @(XMax/2-195,80)"  300` "
  Print @(XMax/2-205,95)"255,0,255"

  Print @(150,420)"Color Mapping: Hue` = Iterations * HueMult + HueStart`"
  Print @(198,435)"                     I     *  ";HMult!
  Print @(486,435)" +   ";HStart!;"`"

  For An = 0 to 359
    Line XMax/2-180+An,500,XMax/2-180+An,599,,HtoRGB(An*HMult!+HStart!,255)

'    Line XMax/2-180+An,500,XMax/2-180+An,550,,HtoRGB(An*HMult!+HStart!,255)
'    Line XMax/2-180+An,550,XMax/2-180+An,599,,HtoRGB(An*HMult!+HStart!,128)
  Next An

  Print @(XMax/2-40,470)"Iterations"
  Print @(XMax/2-185,485)"0"
  Print @(XMax/2-15,485)"180"
  Print @(XMax/2+170,485)"360"
 
  Print @(20,YMax-20)"C)hange M)apping   D)one";

  Do 
    Pause(100)
    Do
      R$ = Inkey$
      Pause(100)
    Loop While R$ = ""

    If R$ = "C" Or R$ = "c" Or R$ = "M" Or R$ = "m" Then
      Box 150,435,400,30,,0,0

      Print @(150,435) "Enter Hue Start` ["+STR$(HStart!)+"`]";
      Input ;Res$
      If Res$ <> "" And Val(Res$) >= -360.0 And Val(Res$) <= 360.0 Then
        HStart! = Val(Res$)
        Refresh = True
      End If
      Print @(150,450)"Enter Hue Multiplier ["+STR$(HMult!)+"]";
      Input ;Res$
      If Res$ <> "" And Val(Res$) <> 0.0 And Val(Res$) >= -100.0 And Val(Res$) <= 100.0 Then
        HMult! = Val(Res$)
        Refresh = True
      End If
      Box 150,435,400,30,,0,0

      Print @(198,435)"                     I     *  ";HMult!
      Print @(486,435)" +   ";HStart!;"`"

      
      If Refresh Then
        For An = 0 to 359
          Line XMax/2-180+An,500,XMax/2-180+An,599,,HtoRGB(An*HMult!+HStart!,255)
    
'          Line XMax/2-180+An,500,XMax/2-180+An,550,,HtoRGB(An*HMult!+HStart!,255)
'          Line XMax/2-180+An,550,XMax/2-180+An,599,,HtoRGB(An*HMult!+HStart!,128)
        Next An
      End If

    End If

  Loop While R$ <> "D" And R$ <> "d" 

  Do While Inkey$ <> "" : Loop

  CLS
End Sub



sub getmod()
  fno% = 0
  if mdir$ = "" then
    print @(0,1) ""
    input "Enter Music Directory Path (ex. /modfiles)"; mdir$
  
    if mdir$ = "" then mdir$ = "/modfiles"
  endif
  
  m$ = dir$(mdir$ + "/" + "*.mod",file)

  do while m$ <> ""
    If InStr(m$,"._") = 0 Then 'Eliminate any hidden metafiles created by MacOS
      md$(fno%) = m$
      fno% = fno% + 1
    End If
    m$ = dir$()
  loop

  for n = 0 to fno%
    if n = 0 then
      fnmaxlen% = len(md$(n))
    else
      if len(md$(n)) > fnmaxlen% then
        fnmaxlen% = len(md$(n))
      end if
    end if
  next
  
  f% = rnd(1)*fno%
  m$ = mdir$+"/"+md$(f%)
  play modfile m$,22050
end sub

sub nextmod()
    Q = Timer
    play stop
    if f% < fno%-1 then
      f% = f% + 1
    else
      f% = 0
    end if
    m$ = mdir$+"/"+md$(f%)
    play modfile m$,22050
end sub



Sub HelpScreen
  'Because we all need a little help sometimes :)
  CLS 
  Do While Inkey$ <> "" : Loop
  Print 
  Print "Mandelbrot Explorer16 V1.3 for Color Maximite 2"
  Print 
  Print "By the Sasquatch"
  Print " With thanks to matherp, vegipete, thwill and yock1960 for your contributions"
  Print "www.thebackshed.com"
  Print : Print
  Print "Nunchuk Controls:                                 Wii Classic Controls:"
  Print "       Joystick - Move cursor                           LJoystick - Move cursor"
  Print "       C Button - re-Center at cursor                    B Button - re-Center at cursor"
  Print "       ZButton - Zoom in at cursor                       X Button - Zoom in at cursor"
  Print "                                                         Y Button - Zoom out at cursor"
  Print "Cursor Command Keys:                                  Home Button - Reset"
  Print "   <Arrow Keys> - Move Cursor                       Select Button - Set Color Map"
  Print "         <Home> - Reset to default coordinates           L Button - Previous Mod Track"      
  Print "              C - re-Center at cursor                    R Button - Next Mod Track"
  Print "              I - zoom In at cursor                      A Button - Change Depth"
  Print "              O - zoom Out at cursor"
  Print "              Z - Enter Zoom Cursor Mode"
  Print "                    +/- - Increase/Decrease Zoom Factor"
  Print "                  <Esc> - Abort Zoom Mode"
  Print "                <Enter> - Zoom to current cursor"
  Print "                    <Z> - Set Zoom Factor and exit"
  Print 
  Print "Color Command Keys:"
  Print "              R - toggle Roll Colors on/off"
  Print "              P - color maPping help screen"
  Print "              M - set color Map shortcut"
  Print 
  Print "Coordinate Command Keys:"
  Print "              D - change Depth (iterations)"
  Print "              T - toggle roll Depth from 16-256"
  Print "              E - Enter new coordinates"
  Print "              L - Toggle Status Line On/Off"
  Print "              U - Undo the last coordinate change"
  Print  
  Print "System Command Keys:"
  Print "              F - File Menu
  Print "            H,? - Help screen"
  Print "              S - Save bitmap file"
  print "              N - Toggle Modfile play"
  Print "              A - Modfile Auto Play 
  Print "            < > - Previous or Next mod track"
  Print "              Q - Quit program"
  Print 
  Print "Note: Press <Enter> at any prompt to retain current value"
  Print : Print
  On Error Skip 1
  Load JPG "Mandelbrotaxes.jpg",XMax-351,240
  Print "Press Q)uit F)ile or any key to load default.dat,TAB key to load user.dat(if exists) startup only."
  Pause(100)
  Do
    R$ = Inkey$
    Pause(100)
  Loop While R$ = ""
  If R$ = "Q" or R$ = "q" Then
    CLS
    End
  End If
  If R$ = "F" or R$ = "f" Then FileMenu
  if ST_Flag = True then
    If R$ = chr$(9) then
      defflg% = 1
    end if
    checkdefault()
    ST_Flag = False
  end if
  CLS
  Do While Inkey$ <> "" : Loop
End Sub




'Mandelbrot16 CSub 
'Mandelbrot16(Depth,Scale,XCenter,YCenter,HueStart,HueMult)
'File mandelbrot16.bas written 28-09-2020 11:40:00
CSUB mandelbrot16
  00000000
  'mandelbrot16
  4FF0E92D 46074CD6 46902000 460E6824 8B10ED2D 9303B087 9A20E9DD 4BD147A0 
  681B4AD1 681B6812 2B006812 F3409202 EE07817C EE063A90 EEB72A90 2A007A00 
  7AE7EEF8 6AE6EEF8 DA27EEC7 DA26EE87 1B00ED96 8169F340 EBC21E59 4CC373C2 
  F501FB02 9101005B 0545EB00 EDCD9304 ED9FDA05 ED9FFBB3 ED9DEBB4 EEB67A05 
  9B035B00 6B04EEB0 7A87EE27 B008F8DD 9B00ED93 7AC7EEB7 ABADED9F 7B45EE37 
  CBADED9F 5B01EE87 9B06EE95 681B4BB0 EE074798 EEB6BA90 683A5B00 7AE7EEB8 
  6B08EEB0 EE272A01 ED967A0D EEB71B00 ED987AC7 EE374B00 EE877B45 EEA55B01 
  F3404B06 2301811D 3B00EEB0 2B00EEB1 7B4EEEB0 6B4EEEB0 8B4EEEB0 BB4EEEB0 
  6B06EE27 42933301 5B49EEB0 7B04EE3B 5B03EEA6 7B48EE37 6B45EEB0 80FAF000 
  BB07EE27 8B06EE26 5B08EE3B 5BC2EEB4 FA10EEF1 EEB7DDE4 EE075BC5 498D3A90 
  DA00EEF7 3A8CEDDF 7AE7EEF8 7AC5EEB1 4A8AED9F 2A8AEDDF 0A8AEDDF 0A8AED9F 
  3A8AED9F 6A63EEF0 2A89ED9F 5A44EEB0 3A10EE17 400A191A EE071A9B EE042A10 
  EEB83A90 EE747A47 EE274AED EEE07A00 EEA26AA4 EE645AA4 EEA65AA4 EEE55AA5 
  ED9A4A25 EEE75B00 EE144A03 191A3A90 1A9B400A 2A90EE06 3A10EE07 4A66EEF8 
  7A6DEE37 4A80EE64 4A87EEA2 3A87EEE0 2A07EE67 6B00ED99 4AA2EEA3 7A22EEA4 
  7A83EEA4 7A42EEE7 7AE7EEB7 6B07EEA5 7B0FEE26 7BC7EEBD 7BC7EEB8 6B4AEEA7 
  6BC0EEB5 FA10EEF1 EE36BF48 EE266B0A EEB76B0C EEFD6BC6 EE177AC6 28050A90 
  8088F200 F000E8DF 3748576A EEB10328 F44F7A04 EEF34378 EE367A0F EE666A47 
  EEFD7A27 EE177AE7 F1C22A90 4318001F 034BEB05 0C02F823 0B01F1BB AF26F47F 
  441D9B04 2B009B01 EE07D05F 3B013A90 7AE7EEF8 E7009301 7A00EEB1 EEF3201F 
  EE367A0F EE666A47 EEFD7A27 EE177AE7 02DB3A90 EEB0E7DB EDDF7A08 201F7A3E 
  6A47EE36 7A27EE66 7AE7EEFD 3A90EE17 033FF1C3 E7CA015B 7A00EEB0 63FCF44F 
  7A0FEEF3 6A47EE36 7A27EE66 7AE7EEFD 0A90EE17 EEB7E7BB 20007A00 7A0FEEF3 
  6A47EE36 7A27EE66 7AE7EEFD 2A90EE17 021FF1C2 F44202D2 E7A863FC 7A25EDDF 
  6A27EE26 6AC6EEBD 3A10EE16 F4410159 E79C4378 034BEB05 F8232200 E79B2C02 
  EE38D0F8 23015B0B B007E705 8B10ECBD 8FF0E8BD 46182300 BF00E789 8000F3AF 
  16C16C17 3F66C16C 00000000 00000000 00000000 40768000 11111111 3F911111 
  08000340 080002F0 080002EC C0D55555 0800033C FF800000 BE8EF46D BEFF712D 
  3EA9E51A 3E6C6078 34000000 3F317218 3FB8AA3B 427C0000 
End CSUB

'To use the function below, rename the CSUB version above to MandelbrotC
'And rename the function below to Mandelbrot (without the B)

'Pure MMBASCIC version of the Mandelbrot Sub
'Fully compatable with the CSUB version
'Runs about 400 times slower than CSUB
'Useful for educaton and experimentation
'Mandelbrot(Depth,Scale,XCenter,YCenter,HueStart,HueMult)
'Variable names shortened for efficiency
Sub Mandelbrot16B(IMax%,Mag!,XCen!,YCen!,HStart!,HMult!)  'Maximum Iterations (Depth), Magnification (Scale)
                                                          'X-Center, Y-Center,HueStart,HueMult
  For HY = YMax To 1 Step - 1    'Step through each Row (Line) of pixels (Y-Axis)
    CY = (HY / YMax - 0.5) / Mag! * 2.5 - YCen!  'Convert Y - screen coordinate

    For HX = XMax TO 1 Step - 1   'Step through each Pixel in the Row (X-Axis)
      CX = (HX / XMax - 0.5) / Mag! * 3.0 + XCen!  'Convert X - screen coordinate

      X = 0.0 : Y = 0.0

      For Iter = 1 to IMax%      'Step from 1 to Maximum Iterations

        XSqr = X * X             'Calculate X^2
        YSqr = Y * Y             'Calculate Y^2

        If XSqr + YSqr > 4.0 Then Exit For  'If "radius" greater than escape value stop 
                                            'C^2 = A^2 + B^2 or R^2 = X^2 + Y^2

        Y = 2.0 * X * Y + CY     'Iterate next value 
        X = XSqr - YSqr + CX     

      Next Iter
 
      If Iter - 1 < IMax% Then   'If we didn't reach the Maximum number of iterations (Depth)
        M = Iter - (Log(log(Sqr(XSqr+YSqr)))) / Log(2.0)  'Calculate partial iteration
        Pixel HX - 1, HY - 1, HtoRGB(M * HMult! + HStart!,255) 'color the pixel based on number of Iterations     
      Else
        Pixel HX - 1, HY - 1, 0  'Otherwise Make the Pixel black
      End If

    Next HX  'Next Pixel in Row
  Next HY    'Next Row of Pixels
End Sub



'Simplified Hue to RGB  Assumes Saturation and Value = 1.0
'Returns 24bit RGB value from Hue in range of 0-360
Function HtoRGB(H,SV)
  local float HS
  local integer i,R,G,B,F
  F = H / 360
  H = H - 360.0 * F
  if H < 0 Then H = 360 + H
  HS = H / 60
  i = Int(HS)
  F = (HS - i) * SV 

 select case i
   case 0
     R = SV : G = F: B = 0
   case 1
     R = SV-F : G = SV : B = 0
   case 2
     R = 0 : G = SV : B = F
   case 3
     R = 0 : G = SV - F : B = SV
   case 4
     R = F : G = 0 : B = SV
   case 5
     R = SV: G = 0:B = SV - F
 end select
 HtoRGB = RGB(R,G,B)
end function
